local unitPath = Path.point{
    x = -1/3,
    y = 1,
}:addLine{
    x = 1/3,
    y = 1,
}:addLine{
    x = 1/3,
    y = 1/3,
}:addLine{
    x = 1,
    y = 1/3,
}:addLine{
    x = 1,
    y = -1/3,
}:addLine{
    x = 1/3,
    y = -1/3,
}:addLine{
    x = 1/3,
    y = -1,
}:addLine{
    x = -1/3,
    y = -1,
}:addLine{
    x = -1/3,
    y = -1/3,
}:addLine{
    x = -1,
    y = -1/3,
}:addLine{
    x = -1,
    y = 1/3,
}:addLine{
    x = -1/3,
    y = 1/3,
}:closeSubpath()
local unitArea = 20/9
local sizeRatio = math.sqrt(4 / unitArea)

CrossPointStamp = function(canvas, x, y, radius, paint)
    local size = (radius or 2) * sizeRatio
    local transformation = Transformation.identity():translate(x, y):scale(size)
    canvas:preserve(function(canvas)
        canvas:concatTransformation(transformation)
            :setPaint(paint)
            :fill(unitPath)
    end)
end

return CrossPointStamp
